/*
 * Decompiled with CFR 0.152.
 */
package com.elenai.elenaidodge.event;

import com.elenai.elenaidodge.ModConfig;
import com.elenai.elenaidodge.api.LedgeGrabEvent;
import com.elenai.elenaidodge.api.WallJumpEvent;
import com.elenai.elenaidodge.capability.walljumpcooldown.IWallJumpCooldown;
import com.elenai.elenaidodge.capability.walljumpcooldown.WallJumpCooldownProvider;
import com.elenai.elenaidodge.capability.walljumps.IWallJumps;
import com.elenai.elenaidodge.capability.walljumps.WallJumpsProvider;
import com.elenai.elenaidodge.init.PotionInit;
import com.elenai.elenaidodge.util.Utils;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class ServerWallJumpEventListener {
    @SubscribeEvent
    public void onServerWallJump(WallJumpEvent.ServerWallJumpEvent event) {
        EntityPlayer player = event.getPlayer();
        Double rayLength = new Double(0.4 + ModConfig.common.wallJump.distance);
        Vec3d playerRotation = Utils.getVectorForHorizontalRotation(event.getPlayer().field_70759_as);
        Vec3d inverseRotation = playerRotation.func_186678_a(-1.0);
        Vec3d rayPath = inverseRotation.func_186678_a(rayLength.doubleValue());
        Vec3d from = player.func_174791_d().func_72441_c(0.0, 0.6, 0.0);
        Vec3d to = from.func_178787_e(rayPath);
        Vec3d playerRotationLeft = Utils.getVectorForHorizontalRotation(event.getPlayer().field_70759_as + (float)ModConfig.common.wallJump.advanced.angle);
        Vec3d inverseRotationLeft = playerRotationLeft.func_186678_a(-1.0);
        Vec3d rayPathLeft = inverseRotationLeft.func_186678_a(rayLength * ModConfig.common.wallJump.advanced.angleLength);
        Vec3d fromLeft = player.func_174791_d().func_72441_c(0.0, 0.2, 0.0);
        Vec3d toLeft = fromLeft.func_178787_e(rayPathLeft);
        Vec3d playerRotationRight = Utils.getVectorForHorizontalRotation(event.getPlayer().field_70759_as - (float)ModConfig.common.wallJump.advanced.angle);
        Vec3d inverseRotationRight = playerRotationRight.func_186678_a(-1.0);
        Vec3d rayPathRight = inverseRotationRight.func_186678_a(rayLength * ModConfig.common.wallJump.advanced.angleLength);
        Vec3d fromRight = player.func_174791_d().func_72441_c(0.0, 0.2, 0.0);
        Vec3d toRight = fromLeft.func_178787_e(rayPathRight);
        RayTraceResult ctx = player.field_70170_p.func_72933_a(from, to);
        RayTraceResult ctxLeft = player.field_70170_p.func_72933_a(fromLeft, toLeft);
        RayTraceResult ctxRight = player.field_70170_p.func_72933_a(fromRight, toRight);
        if (ctx != null && player.field_70170_p.func_180495_p(ctx.func_178782_a()).func_185904_a().func_76220_a()) {
            event.setDirection(WallJumpEvent.Direction.valueOf(ctx.field_178784_b.func_176610_l().toUpperCase()));
        } else if (ctxLeft != null && player.field_70170_p.func_180495_p(ctxLeft.func_178782_a()).func_185904_a().func_76220_a()) {
            event.setDirection(WallJumpEvent.Direction.valueOf(ctxLeft.field_178784_b.func_176610_l().toUpperCase()));
        } else if (ctxRight != null && player.field_70170_p.func_180495_p(ctxRight.func_178782_a()).func_185904_a().func_76220_a()) {
            event.setDirection(WallJumpEvent.Direction.valueOf(ctxRight.field_178784_b.func_176610_l().toUpperCase()));
        } else {
            LedgeGrabEvent.ServerLedgeGrabEvent lgEvent = new LedgeGrabEvent.ServerLedgeGrabEvent(ModConfig.common.ledgeGrab.forwardsForce, player, 0, LedgeGrabEvent.Direction.valueOf(player.func_174811_aO().func_176610_l().toUpperCase()));
            if (!MinecraftForge.EVENT_BUS.post((Event)lgEvent)) {
                Utils.handleLedgeGrab(lgEvent, (EntityPlayerMP)player);
            }
            event.setCanceled(true);
        }
        Double floorRayLength = new Double(0.9);
        Vec3d rayPathFloor = new Vec3d(0.0, -1.0, 0.0).func_186678_a(floorRayLength.doubleValue());
        Vec3d fromPlayer = player.func_174791_d();
        Vec3d toFloor = fromPlayer.func_178787_e(rayPathFloor);
        RayTraceResult ctxFloor = player.field_70170_p.func_72933_a(fromPlayer, toFloor);
        if (ctxFloor != null && player.field_70170_p.func_180495_p(ctxFloor.func_178782_a()).func_185904_a().func_76220_a()) {
            event.setCanceled(true);
        }
        if (!ModConfig.common.wallJump.enable && !Loader.isModLoaded((String)"reskillable") || !Utils.wallJumpTraitUnlocked(event.getPlayer())) {
            event.setCanceled(!player.func_70644_a(PotionInit.NIMBLE_EFFECT));
        }
        if (event.getDirection() != null) {
            IWallJumpCooldown wjc;
            switch (event.getDirection()) {
                case NORTH: {
                    if (!(playerRotation.field_72449_c > 0.0 - ModConfig.common.wallJump.angle)) break;
                    event.setCanceled(true);
                    break;
                }
                case EAST: {
                    if (!(playerRotation.field_72450_a < 0.0 + ModConfig.common.wallJump.angle)) break;
                    event.setCanceled(true);
                    break;
                }
                case SOUTH: {
                    if (!(playerRotation.field_72449_c < 0.0 + ModConfig.common.wallJump.angle)) break;
                    event.setCanceled(true);
                    break;
                }
                case WEST: {
                    if (!(playerRotation.field_72450_a > 0.0 - ModConfig.common.wallJump.angle)) break;
                    event.setCanceled(true);
                    break;
                }
            }
            IWallJumps w = (IWallJumps)player.getCapability(WallJumpsProvider.WALLJUMPS_CAP, null);
            if (w.getWallJumps() + 1 > ModConfig.common.wallJump.maximum && ModConfig.common.wallJump.maximum != 0) {
                event.setCanceled(true);
            }
            if (player.func_71024_bL().func_75116_a() <= ModConfig.common.wallJump.hunger) {
                event.setCanceled(true);
            }
            if (!ModConfig.common.wallJump.falling && player.field_71095_bQ > player.field_70163_u) {
                event.setCanceled(true);
            }
            if (player.func_184812_l_() || player.func_175149_v()) {
                event.setCanceled(true);
            }
            if ((double)player.field_70143_R > ModConfig.common.wallJump.fallDistance && ModConfig.common.wallJump.fallDistance != 0.0) {
                event.setCanceled(true);
            }
            if (player.func_184218_aH()) {
                event.setCanceled(true);
            }
            if ((wjc = (IWallJumpCooldown)player.getCapability(WallJumpCooldownProvider.WALLJUMPCOOLDOWN_CAP, null)).getWallJumps() > 0) {
                event.setCanceled(true);
            }
            if (!ModConfig.common.wallJump.oneBlock && event.getPlayer().field_70170_p.func_180495_p(event.getPlayer().func_180425_c().func_177972_a(EnumFacing.func_176739_a((String)event.getDirection().name().toUpperCase()))).func_185904_a().func_76230_c()) {
                event.setCanceled(true);
            }
        } else {
            event.setCanceled(true);
        }
    }
}

